/*********************************************************
 * Copyright (C) 2007 VMware, Inc. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation version 2 and no later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA
 *
 *********************************************************/

/*
 * backdoor_balloon.h --
 *
 *    This file provides a wrapper for using the more generic backdoor library
 *    together with the vmballoon-specific backdoor.
 */

#ifndef _BACKDOOR_BALLOON_H_
#define _BACKDOOR_BALLOON_H_

#include "vmballoon.h"
#include "backdoor.h"
#include "balloon_def.h"

int Backdoor_MonitorStart(Balloon *b, uint32 protoVersion);
int Backdoor_MonitorGuestType(Balloon *b);
int Backdoor_MonitorGetTarget(Balloon *b, uint32 *target);
int Backdoor_MonitorLockPage(Balloon *b, PPN64 ppn, uint32 *target);
int Backdoor_MonitorUnlockPage(Balloon *b, PPN64 ppn, uint32 *target);
int Backdoor_MonitorLockPagesBatched(Balloon *b, PPN64 ppn, uint32 nPages,
                                     uint32 *target);
int Backdoor_MonitorUnlockPagesBatched(Balloon *b, PPN64 ppn, uint32 nPages,
                                       uint32 *target);

#endif /* _BACKDOOR_BALLOON_H_ */
