#!/usr/bin/perl
#WHMADDON:addonupdates:ConfigServer <b>Mail Manage</b>
#ACLS:configserver
###############################################################################
# Copyright 2006-2015, Way to the Web Limited
# URL: http://www.waytotheweb.com
# Email: sales@waytotheweb.com
###############################################################################
use Sys::Hostname qw(hostname);
use IPC::Open3;
use File::Basename;
use lib '/usr/local/cpanel';
use Cpanel::cPanelFunctions ();
use Cpanel::Form			();
use Cpanel::Config          ();               
use Whostmgr::ACLS			();
use Cpanel::SafeFile		();
use Cpanel::Rlimit			();
use Cpanel::Version::Tiny	();
###############################################################################
# start main
my %FORM = Cpanel::Form::parseform();

print "Content-type: text/html\r\n\r\n";

Whostmgr::ACLS::init_acls();
if (!Whostmgr::ACLS::hasroot()) {
    print "You do not have access to this option.\n";
	exit();
}

Cpanel::Rlimit::set_rlimit_to_infinity();

if (-e "/usr/local/cpanel/bin/register_appconfig") {
	$script = "cmm.cgi";
	$images = "cmm";
	$versionfile = "/usr/local/cpanel/whostmgr/docroot/cgi/configserver/cmm/cmmversion.txt";
} else {
	$script = "addon_cmm.cgi";
	$images = "cmm";
	$versionfile = "/usr/local/cpanel/whostmgr/docroot/cgi/cmmversion.txt";
}

open (IN, "<$versionfile") or die $!;
$myv = <IN>;
close (IN);
chomp $myv;

unless (-e "/etc/csuibuttondisable") {
print <<EOF;
<!DOCTYPE html>
<HTML>
<HEAD>
<TITLE>ConfigServer Mail Manage</TITLE>
<style type="text/css">
a {
	color: #000000;
	text-decoration: underline;
}
td {
	font-family:Arial, Helvetica, sans-serif;
	font-size:small;
}
body {
	font-family:Arial, Helvetica, sans-serif;
	font-size:small;
}
pre {
	font-family: Courier New, Courier;
	font-size: 12px;
}
.input {
	min-width:0px;
	padding:3px;
	background:#FFFFFF;
	border-radius:3px;
	border:1px solid #A6C150;
	color:#990000 !important;
	font-family:Verdana, Geneva, sans-serif;
	text-shadow: 0px 1px 1px #CDCDCD;
	font-size:13px;
	font-weight:normal;
	margin:2px;
}
.input:hover {
	cursor:pointer;
	border:1px solid #A6C150;
	box-shadow: 0px 0px 6px 1px #A6C150;
}
input[type=password], input[type=text], textarea, select {
  -webkit-transition: all 0.30s ease-in-out;
  -moz-transition: all 0.30s ease-in-out;
  -ms-transition: all 0.30s ease-in-out;
  -o-transition: all 0.30s ease-in-out;
  border-radius:3px;
  outline: none;
  padding: 3px 0px 3px 3px;
  margin: 5px 1px 3px 0px;
  border: 1px solid #DDDDDD;
}
input[type=password]:focus, input[type=text]:focus, textarea:focus, select:focus {
  box-shadow: 0 0 5px #CC0000;
  padding: 3px 0px 3px 3px;
  margin: 5px 1px 3px 0px;
  border: 1px solid #CC0000;
}
.tdshade1_noborder{background:#FFFFFF;}
.tdshade2_noborder{background:#F4F4EA;}
.tdshadeyellow{background:lightyellow;}
</style>
</HEAD>
<BODY>
EOF
} else {
print <<EOF;
<!DOCTYPE html>
<HTML>
<HEAD>
<TITLE>ConfigServer Mail Manage</TITLE>
<style type="text/css">
a {
	color: #000000;
	text-decoration: underline;
}
a:hover {
	position: relative;
	top: 1px;
	left: 1px;
}
td {
	font-family:Arial, Helvetica, sans-serif;
	font-size:small;
}
body {
	font-family:Arial, Helvetica, sans-serif;
	font-size:small;
}
pre {
	font-family: Courier New, Courier;
	font-size: 12px;
}
.tdshade1_noborder{background:#FFFFFF;}
.tdshade2_noborder{background:#F4F4EA;}
.tdshadeyellow{background:lightyellow;}
</style>
</HEAD>
<BODY>
EOF
}
print "<p><b style='font-size: 16px'>ConfigServer Mail Manage - cmm v$myv</b></p>\n";

$| = 1;

my $mailscanner = 0;
if (-e "/usr/mscpanel/version.txt") {$mailscanner = 1}

if ($FORM{domain} ne "" and $FORM{domain} =~ /[^\w\-\.]/) {
	print "Invalid domain name [$FORM{domain}]";
}
elsif ($FORM{account} ne "" and $FORM{account} =~ /[^a-zA-Z0-9\-\_\.\@\+]/) {
	print "Invalid account name [$FORM{account}]";
}
elsif ($FORM{action} eq "Manage Mail Forwarders") {
	my %userdomains;
	my $inlock = Cpanel::SafeFile::safeopen(\*IN,"<","/etc/userdomains");
	my @localusers = <IN>;
	Cpanel::SafeFile::safeclose(\*IN,$inlock);
	chomp @localusers;
	foreach my $line (@localusers) {
		my ($domain,$user) = split(/\:\s*/,$line,2);
		$userdomains{$domain} = $user;
	}
	print "<br><div align='center'><form action='$script' method='post'><input type='hidden' name='domain' value='$FORM{domain}'><input type='submit' class='input' name='action' value='Manage Mail Accounts'>&nbsp;&nbsp;<input type='submit' class='input' name='action' value='Manage Mail Filters'>&nbsp;&nbsp;<input type='submit' class='input' name='action' value='Manage Mail Hourly Limits'></form></div>\n";
	print "<table align='center' width='95%' border='0' cellspacing='0' cellpadding='4' bgcolor='#FFFFFF' style='border:1px solid #990000'>\n";
	print "<tr><th align='left' colspan='2'>Mail Forwarders for $FORM{domain}</th></tr>";
	print "<tr><th align='left'>Forwarder</th><th>Recipient</th></tr>";

	my $class = "tdshade2_noborder";
	my $total = 0;
	open (IN, "</etc/valiases/$FORM{domain}");
	my @forwarders = <IN>;
	close (IN);
	chomp @forwarders;
	foreach my $aliases (@forwarders) {
		my ($alias,$recipient) = split(/: /,$aliases,2);
		if ($alias eq "*") {$alias .= " (Default Address)"}
		print "<tr class='$class'><td>$alias</td><td>$recipient</td></tr>\n";
		if ($class eq "tdshade2_noborder") {$class = "tdshade1_noborder"} else {$class = "tdshade2_noborder"}
		$total++;
	}
	unless ($total) {print "<tr class='$class'><td colspan='2' align='center'>No entries found</td></tr>\n"}
	print "<tr class='scellheader' align='center'><td colspan='2'>";
	my ($childin, $childout);
	my $cmdpid = open3($childin, $childout, $childout, "/usr/bin/quota", "-qlu", $userdomains{$FORM{domain}});
	my @data = <$childout>;
	waitpid ($cmdpid, 0);
	chomp @data;
	if ($data[0] =~ /Block limit reached/) {
		print "<p>cPanel account over quota - editing disabled</p>";
	} else {
		print "<br><form action='$script' method='post'><input type='hidden' name='domain' value='$FORM{domain}'><input type='submit' class='input' name='action' value='Edit Mail Forwarders'></form>";
	}
	print "</td></tr>\n";
	print "</table>\n";
	print "<p>Total Accounts: $total</p>\n";
	print "<p align='center'><form action='$script' method='post'><input type='submit' class='input' value='Return'></form></p>\n";
}
elsif ($FORM{action} eq "Edit Mail Forwarders") {
	my $inlock = Cpanel::SafeFile::safeopen(\*IN,"<","/etc/valiases/$FORM{domain}");
	my @confdata = <IN>;
	Cpanel::SafeFile::safeclose(\*IN,$inlock);
	chomp @confdata;
	my $max = 80;
	foreach my $line (@confdata) {if (length($line) > $max) {$max = length($line) + 1}}

	print "<form action='$script' method='post'><input type='hidden' name='domain' value='$FORM{domain}'>\n";
	print "<input type='hidden' name='action' value='saveforwarders'>\n";
	print "<fieldset><legend><b>Edit /etc/valiases/$FORM{domain}</b></legend>\n";
	print "<table style='border: 1px black solid' align='center'>\n";
	print "<tr><td><textarea name='formdata' cols='$max' rows='40' style='font-family: Courier New, Courier; font-size: 12px'>\n";
	foreach my $line (@confdata) {
		print $line."\n";;
	}
	print "</textarea></td></tr></table></fieldset>\n";
	print "<p align='center'><input type='submit' class='input' value='Change'></p>\n";
	print "</form>\n";
	print "<p align='center'><form action='javascript:history.go(-1)' method='post'><input type='submit' class='input' value='Go Back'></form></p>\n";
	print "<p align='center'><form action='$script' method='post'><input type='submit' class='input' value='Return'></form></p>\n";
}
elsif ($FORM{action} eq "saveforwarders") {
	$FORM{formdata} =~ s/\r//g;
	my $outlock = Cpanel::SafeFile::safeopen(\*OUT,">","/etc/valiases/$FORM{domain}");
	print OUT $FORM{formdata};
	Cpanel::SafeFile::safeclose(\*OUT,$outlock);

	my %userdomains;
	my $inlock = Cpanel::SafeFile::safeopen(\*IN,"<","/etc/userdomains");
	my @localusers = <IN>;
	Cpanel::SafeFile::safeclose(\*IN,$inlock);
	chomp @localusers;
	foreach my $line (@localusers) {
		my ($domain,$user) = split(/\: /,$line,2);
		$userdomains{$domain} = $user;
	}
	chown ((getpwnam($userdomains{$FORM{domain}}))[2],(getgrnam("mail"))[2],"/etc/valiases/$FORM{domain}");

	print "<p>Changes saved.</p>\n";
	print "<p align='center'><form action='$script' method='post'><input type='hidden' name='domain' value='$FORM{domain}'><input type='hidden' name='action' value='Manage Mail Forwarders'><input type='submit' class='input' value='Return'></form></p>\n";
}
elsif ($FORM{action} eq "Manage Mail Filters") {
	my %userdomains;
	my $inlock = Cpanel::SafeFile::safeopen(\*IN,"<","/etc/userdomains");
	my @localusers = <IN>;
	Cpanel::SafeFile::safeclose(\*IN,$inlock);
	chomp @localusers;
	foreach my $line (@localusers) {
		my ($domain,$user) = split(/\: /,$line,2);
		$userdomains{$domain} = $user;
	}
	print "<br><div align='center'><form action='$script' method='post'><input type='hidden' name='domain' value='$FORM{domain}'><input type='submit' class='input' name='action' value='Manage Mail Forwarders'>&nbsp;&nbsp;<input type='submit' class='input' name='action' value='Manage Mail Accounts'>&nbsp;&nbsp;<input type='submit' class='input' name='action' value='Manage Mail Hourly Limits'></form></div>\n";
	print "<table align='center' width='95%' border='0' cellspacing='0' cellpadding='4' bgcolor='#FFFFFF' style='border:1px solid #990000'>\n";
	print "<tr><th align='left'>Mail Filters for $FORM{domain}</th></tr>";
	my $class = "tdshade2_noborder";
	if (-z "/etc/vfilters/$FORM{domain}") {
		print "<tr class='$class'><td align='center'>No entries found</td></tr>\n";
	} else {
		print "<tr class='$class'><td><pre>\n";
		open (IN, "</etc/vfilters/$FORM{domain}");
		my @data = <IN>;
		close (IN);
		foreach my $line (@data) {
			$line =~ s/&/&amp;/g;
			$line =~ s/>/&gt;/g;
			$line =~ s/</&lt;/g;
			print $line;
		}
	}
	print "</pre></td></tr>\n";
	print "<tr><th>\n";
	my ($childin, $childout);
	my $cmdpid = open3($childin, $childout, $childout, "/usr/bin/quota", "-qlu", $userdomains{$FORM{domain}});
	my @data = <$childout>;
	waitpid ($cmdpid, 0);
	chomp @data;
	if ($data[0] =~ /Block limit reached/) {
		print "<p>cPanel account over quota - editing disabled</p>";
	} else {
		print "<br><form action='$script' method='post'><input type='hidden' name='domain' value='$FORM{domain}'><input type='submit' class='input' name='action' value='Edit Mail Filters'></form>\n";
	}
	print "</th></tr>\n";
	print "</table>\n";
	print "<p align='center'><form action='$script' method='post'><input type='submit' class='input' value='Return'></form></p>\n";
}
elsif ($FORM{action} eq "Edit Mail Filters") {
	my $inlock = Cpanel::SafeFile::safeopen(\*IN,"<","/etc/vfilters/$FORM{domain}");
	my @confdata = <IN>;
	Cpanel::SafeFile::safeclose(\*IN,$inlock);
	chomp @confdata;
	my $max = 80;
	foreach my $line (@confdata) {if (length($line) > $max) {$max = length($line) + 1}}

	print "<form action='$script' method='post'><input type='hidden' name='domain' value='$FORM{domain}'>\n";
	print "<input type='hidden' name='action' value='savefilters'>\n";
	print "<fieldset><legend><b>Edit /etc/vfilters/$FORM{domain}</b></legend>\n";
	print "<table style='border: 1px black solid' align='center'>\n";
	print "<tr><td><textarea name='formdata' cols='$max' rows='40' style='font-family: Courier New, Courier; font-size: 12px'>\n";
	foreach my $line (@confdata) {
		print $line."\n";;
	}
	print "</textarea></td></tr></table></fieldset>\n";
	print "<p align='center'><input type='submit' class='input' value='Change'></p>\n";
	print "</form>\n";
	print "<p align='center'><form action='javascript:history.go(-1)' method='post'><input type='submit' class='input' value='Go Back'></form></p>\n";
	print "<p align='center'><form action='$script' method='post'><input type='submit' class='input' value='Return'></form></p>\n";
}
elsif ($FORM{action} eq "savefilters") {
	$FORM{formdata} =~ s/\r//g;
	my $outlock = Cpanel::SafeFile::safeopen(\*OUT,">","/etc/vfilters/$FORM{domain}");
	print OUT $FORM{formdata};
	Cpanel::SafeFile::safeclose(\*OUT,$outlock);

	my %userdomains;
	my $inlock = Cpanel::SafeFile::safeopen(\*IN,"<","/etc/userdomains");
	my @localusers = <IN>;
	Cpanel::SafeFile::safeclose(\*IN,$inlock);
	chomp @localusers;
	foreach my $line (@localusers) {
		my ($domain,$user) = split(/\: /,$line,2);
		$userdomains{$domain} = $user;
	}
	chown ((getpwnam($userdomains{$FORM{domain}}))[2],(getgrnam("mail"))[2],"/etc/vfilters/$FORM{domain}");

	print "<p>Changes saved.</p>\n";
	print "<p align='center'><form action='$script' method='post'><input type='submit' class='input' value='Return'></form></p>\n";
}
elsif ($FORM{action} eq "Manage Mail Hourly Limits") {
	if ($FORM{domain} ne "") {
		my $cpconf = Cpanel::Config::loadcpconf();
		my $maxemails = $cpconf->{maxemailsperhour};
		my $account;
		my %userdomains;
		my $usermaxemails;
		my $domainmaxemails;
		my $inlock = Cpanel::SafeFile::safeopen(\*IN,"<","/etc/userdomains");
		my @localusers = <IN>;
		Cpanel::SafeFile::safeclose(\*IN,$inlock);
		chomp @localusers;
		foreach my $line (@localusers) {
			my ($domain,$user) = split(/\: /,$line,2);
			$userdomains{$domain} = $user;
		}
		$account = $userdomains{$FORM{domain}};

		$inlock = Cpanel::SafeFile::safeopen(\*IN,"<","/var/cpanel/users/$userdomains{$FORM{domain}}");
		my @confdata = <IN>;
		Cpanel::SafeFile::safeclose(\*IN,$inlock);
		chomp @confdata;

		foreach my $line (@confdata) {
			if ($line =~ /^MAX_EMAIL_PER_HOUR=(\d+)/) {$usermaxemails = $1}
			if ($line =~ /^MAX_EMAIL_PER_HOUR-$FORM{domain}=(\d+)/) {$domainmaxemails = $1}
		}
		if ($usermaxemails > 0) {$maxemails = $usermaxemails}
		if ($domainmaxemails > 0) {$maxemails = $domainmaxemails}
		if ($maxemails eq "") {$maxemails = 0}

		print "<form action='$script' method='post'><input type='hidden' name='domain' value='$FORM{domain}'>\n";
		print "<input type='hidden' name='action' value='savelimits'>\n";
		print "<fieldset><legend><b>Edit Mail Hourly limits for $FORM{domain}</b></legend>\n";
		print "<table style='border: 1px black solid' align='center'>\n";
		print "<tr><td>$FORM{domain} can send a maximum of <input type='text' value='$maxemails' name='maxemails'> per hour [0 = unlimited]</td></tr>\n";
		print "</table></fieldset>\n";
		print "<p align='center'><input type='submit' class='input' value='Change'></p>\n";
		print "</form>\n";
	} else {
		print "<p align='center'><b>You must select a domain first</b></p>\n";
	}
	print "<p align='center'><form action='javascript:history.go(-1)' method='post'><input type='submit' class='input' value='Go Back'></form></p>\n";
}
elsif ($FORM{action} eq "savelimits") {
	my %userdomains;
	my $inlock = Cpanel::SafeFile::safeopen(\*IN,"<","/etc/userdomains");
	my @localusers = <IN>;
	Cpanel::SafeFile::safeclose(\*IN,$inlock);
	chomp @localusers;
	foreach my $line (@localusers) {
		my ($domain,$user) = split(/\: /,$line,2);
		$userdomains{$domain} = $user;
	}

	$inlock = Cpanel::SafeFile::safeopen(\*IN,"<","/var/cpanel/users/$userdomains{$FORM{domain}}");
	my @confdata = <IN>;
	Cpanel::SafeFile::safeclose(\*IN,$inlock);
	chomp @confdata;

	my @newconfdata;
	foreach my $line (@confdata) {
		if ($line =~ /^MAX_EMAIL_PER_HOUR-$FORM{domain}=(\d+)/) {next}
		push @newconfdata,$line;
	}
	push @newconfdata, "MAX_EMAIL_PER_HOUR-$FORM{domain}=$FORM{maxemails}";

	my $outlock = Cpanel::SafeFile::safeopen(\*OUT,">","/var/cpanel/users/$userdomains{$FORM{domain}}");
	foreach my $line (@newconfdata) {print OUT "$line\n"}
	Cpanel::SafeFile::safeclose(\*OUT,$outlock);

	my $cmd = "/scripts/update_email_limits $userdomains{$FORM{domain}}";
	if ($Cpanel::Version::Tiny::parent_version >= 11 and $Cpanel::Version::Tiny::major_version >=32) {
		$cmd = "/scripts/updateuserdomains";
	}
	my ($childin, $childout);
	my $cmdpid = open3($childin, $childout, $childout, $cmd);
	my @data = <$childout>;
	waitpid ($cmdpid, 0);
	chomp @data;
	print "<p>$cmd</p>\n";
	foreach my $line (@data) {
		print "$line<br />\n";
	}
	print "<p>Changes saved.</p>\n";
	print "<p align='center'><form action='$script' method='post'><input type='submit' class='input' value='Return'></form></p>\n";
}
elsif ($FORM{action} eq "viewmail") {
	if (-f $FORM{file}) {
		my %userdomains;
		my $inlock = Cpanel::SafeFile::safeopen(\*IN,"<","/etc/userdomains");
		my @localusers = <IN>;
		Cpanel::SafeFile::safeclose(\*IN,$inlock);
		chomp @localusers;
		foreach my $line (@localusers) {
			my ($domain,$user) = split(/\: /,$line,2);
			$userdomains{$domain} = $user;
		}
		my ($file, $filedir) = fileparse($FORM{file});
		my $homedir = ( getpwnam($userdomains{$FORM{domain}}) )[7];
		if ($homedir eq "" or $filedir !~ /^$homedir/) {
			print "Invalid file [$FORM{file}]";
		} else {
			print "<p align='center'><u><b><a href='javascript: window.close()'>Close Window</a></b></u></p>\n";
			print "<table align='center' width='95%' border='0' cellspacing='0' cellpadding='4' bgcolor='#FFFFFF' style='border:1px solid #990000'>\n";
			print "<tr><th align='left'>View Email</th></tr>";
			my $class = "tdshade2_noborder";
			print "<tr class='$class'><td><pre>\n";
			my @mail;
			open (IN, "<$FORM{file}");
			unless ($FORM{f}) {
				my $x;
				for ($x = 0; $x < 500;$x++) {
					my $line  = <IN>;
					$line =~ s/&/&amp;/g;
					$line =~ s/>/&gt;/g;
					$line =~ s/</&lt;/g;
					print $line;
				}
				unless (eof (IN)) {
					my $size = int((stat("$FORM{file}"))[7] / 1024);
					print "</pre>\n";
					print "...[truncated to 500 lines] <u><b><a href=\"$script?action=viewmail&f=1&domain=$FORM{domain}&file=$FORM{file}\">View full ($size KB) email</a></u></b>\n";
				} else {
					print "</pre>";
				}
			} else {
				while (my $line = <IN>) {
					$line =~ s/&/&amp;/g;
					$line =~ s/>/&gt;/g;
					$line =~ s/</&lt;/g;
					print $line;
				}
				print "</pre>";
			}
			close (IN);
			print "</td></tr>\n";
			print "</table>\n";
		}
	} else {
		print "File [$FORM{file}] not found";
	}
	print "<p align='center'><u><b><a href='javascript: window.close()'>Close Window</a></b></u></p>\n";
}
elsif ($FORM{action} eq "empty") {
	print "<form action='$script' method='post'>\n";
	print "<table align='center' width='95%' border='0' cellspacing='0' cellpadding='4' bgcolor='#FFFFFF' style='border:1px solid #990000'>\n";
	print "<tr><th align='left' colspan='2'>Empty Mailbox $FORM{account}\@$FORM{domain}</th></tr>";
	print "<tr class='tdshade2_noborder'><td><b>Are you sure that you want to irretrievably delete all of the email within this mailbox?</b></td></tr>\n";
	print "<tr class='tdshade1_noborder' align='center'><td><input type='submit' class='input' name='action' value='Empty Mailbox'></td></tr>\n";
	print "</table>\n";
	print "<input type='hidden' name='account' value='$FORM{account}'><input type='hidden' name='domain' value='$FORM{domain}'><input type='hidden' name='top' value='$FORM{top}'></form>\n";
	print "<p align='center'><form action='$script' method='post'><input type='hidden' name='domain' value='$FORM{domain}'><input type='hidden' name='action' value='Manage Mail Accounts'><input type='submit' class='input' value='Return'></form></p>\n";
}
elsif ($FORM{action} eq "Empty Mailbox") {
	my %userdomains;
	my $inlock = Cpanel::SafeFile::safeopen(\*IN,"<","/etc/userdomains");
	my @localusers = <IN>;
	Cpanel::SafeFile::safeclose(\*IN,$inlock);
	chomp @localusers;
	foreach my $line (@localusers) {
		my ($domain,$user) = split(/\: /,$line,2);
		$userdomains{$domain} = $user;
	}
	my $dir;
	my $title;
	if ($FORM{top}) {
		my $homedir = ( getpwnam($FORM{account}) )[7];
		$dir = "$homedir/mail";
		$title = "$FORM{account} (cPanel user)";
	} else {
		my $homedir = ( getpwnam($userdomains{$FORM{domain}}) )[7];
		$dir = "$homedir/mail/$FORM{domain}/$FORM{account}";
		$title = "$FORM{account}\@$FORM{domain}";
	}

	print "<table align='center' width='95%' border='0' cellspacing='0' cellpadding='4' bgcolor='#FFFFFF' style='border:1px solid #990000'>\n";
	print "<tr><th align='left'>$title</th></tr>";
	print "<tr><td>\n";

	my @maildirs;
	push @maildirs, $dir;
	opendir (DIR, $dir);
	while (my $file = readdir(DIR)) {
		if ($file eq ".") {next}
		if ($file eq "..") {next}
		if (readlink "$dir/$file") {next}
		if ((-d "$dir/$file") and (-d "$dir/$file/cur") and (-d "$dir/$file/new") and (-d "$dir/$file/tmp")) {push @maildirs, "$dir/$file"}
	}
	closedir (DIR);
	my $total = 0;
	foreach my $line (@maildirs) {
		foreach my $subdir ("/","/cur","/new","/tmp") {
			opendir (DIR, "$line$subdir");
			while (my $file = readdir(DIR)) {
				if ((-f "$line$subdir/$file") and ($file =~ /^\d+\./)) {
					print ". ";
					unlink ("$line$subdir/$file");
					$total++;
				}
			}
			closedir (DIR);
		}
		if (-e "$line$subdir/maildirsize") {unlink "$line$subdir/maildirsize"}
	}
	print "<p>Total emails removed: $total</p></td></tr>\n";
	print "</table>\n";
	print "<p align='center'><form action='$script' method='post'><input type='hidden' name='domain' value='$FORM{domain}'><input type='hidden' name='action' value='Manage Mail Accounts'><input type='submit' class='input' value='Return'></form></p>\n";
}
elsif ($FORM{action} eq "view") {
	my %userdomains;
	my $inlock = Cpanel::SafeFile::safeopen(\*IN,"<","/etc/userdomains");
	my @localusers = <IN>;
	Cpanel::SafeFile::safeclose(\*IN,$inlock);
	chomp @localusers;
	foreach my $line (@localusers) {
		my ($domain,$user) = split(/\: /,$line,2);
		$userdomains{$domain} = $user;
	}
	my $dir;
	my $title;
	if ($FORM{top}) {
		my $homedir = ( getpwnam($FORM{account}) )[7];
		$dir = "$homedir/mail";
		$title = "$FORM{account} (cPanel user)";
	} else {
		my $homedir = ( getpwnam($userdomains{$FORM{domain}}) )[7];
		$dir = "$homedir/mail/$FORM{domain}/$FORM{account}";
		$title = "$FORM{account}\@$FORM{domain}";
	}

	my $topdir = $FORM{topdir};
	if ($topdir eq "") {$topdir = "/"}
	print "<script>\n";
	print "function confirmSubmit() {\n";
	print "var agree=confirm('Are you sure you wish to empty the directory?');\n";
	print "if (agree)\n	return true ;\nelse\n	return false ;\n";
	print "}\n";
	print "</script>\n";

	if ($topdir eq "/") {
		print "<table align='center' width='95%' border='0' cellspacing='0' cellpadding='4' bgcolor='#FFFFFF' style='border:1px solid #990000'>\n";
		print "<tr><th align='left' colspan='6'>$title</th></tr>";
		print "<tr align='center'><th>&nbsp;</th><th>Directory</th><th>Mail Count</th><th colspan='3'>Size</th></tr>\n";
	} else {
		my $showdir = "$topdir";
		$showdir =~ s/\/+/\//g;
		print "<script>\n";
		print "function checkme() {\n";
		print "	for (var x = 0; x < document.listmail.elements.length; x++) {\n";
		print "		var check = document.listmail.elements[x];\n";
		print "	    if (document.listmail.elements[x].name != 'checkall') {\n";
		print "			check.checked = document.listmail.checkall.checked;\n";
		print "		}\n";
		print "	}\n";
		print "}\n";
		print "RegExp.escape = function(text) {\n";
		print "		if (!arguments.callee.sRE) {\n";
		print "			var specials = ['/', '.', '*', '+', '?', '|','(', ')', '[', ']', '{', '}', '\\\\'];\n";
		print "				arguments.callee.sRE = new RegExp('(\\\\' + specials.join('|\\\\') + ')', 'g');\n";
		print "			}\n";
		print "	 	return text.replace(arguments.callee.sRE, '\\\\\$1');\n";
		print "}\n";
		print "function selectSearch(){\n";
		print "		var reg = new RegExp(RegExp.escape(document.listmail.searchFor.value), 'i');\n";
		print "		for (var x = 0; x < document.listmail.elements.length; x++) {\n";
		print "			if (document.listmail.elements[x].type == 'checkbox' && document.listmail.elements[x].name != 'checkall') {\n";
		print "				var trPai = document.listmail.elements[x].parentNode.parentNode;\n";
		print "				var allTds = trPai.getElementsByTagName('TD');\n";
		print "				var theLink = allTds[2].getElementsByTagName('A');\n";
		print "				if( reg.test(theLink[0].innerHTML) ){\n";
		print "					document.listmail.elements[x].checked = true;\n";
		print "				}\n";
		print "			}\n";
		print "		}\n";
		print "}\n</script>\n";
		print "<form action='$script' method='post' name='listmail'><input type='hidden' name='domain' value='$FORM{domain}'><input type='hidden' name='account' value='$FORM{account}'><input type='hidden' name='action' value='bulkdelete'><input type='hidden' name='topdir' value='$topdir'><input type='hidden' name='top' value='$FORM{top}'>\n";
		print "<table align='center' width='95%' border='0' cellspacing='0' cellpadding='4' bgcolor='#FFFFFF' style='border:1px solid #990000'>\n";
		print "<tr><th align='left' colspan='6'>$title</th></tr>";
		print "<tr class='tdshade1_noborder'><td colspan='6' align='center'><b>$showdir</b> <a href=\"$script?action=view&domain=$FORM{domain}&account=$FORM{account}&top=$FORM{top}\" title='Go Up'><img border='0' src='$images/up.png'></a> <a href=\"$script?action=emptydir&domain=$FORM{domain}&account=$FORM{account}&file=$dir$showdir\" title='Empty Directory' target='_blank' onClick='return confirmSubmit()'><img border='0' src='$images/empty.png'></a>";
		if ($mailscanner) {print " <a href=\"$script?action=salearn&domain=$FORM{domain}&account=$FORM{account}&file=$dir$showdir\" title='Run SA Learn for spam' target='_blank'><img border='0' src='$images/sa.jpg'></a>"}
		print "</td></tr>\n";
		print "<tr align='center'><th>\#</th><th>Del</th><th>Subject</th><th>Date</th><th>Size</th><th>&nbsp;</th></tr>\n";
	}

	my @maildirs;
	push @maildirs, "/";
	opendir (DIR, $dir);
	while (my $file = readdir(DIR)) {
		if ($file eq ".") {next}
		if ($file eq "..") {next}
		if (readlink "$dir/$file") {next}
		if ((-d "$dir/$file") and (-d "$dir/$file/cur") and (-d "$dir/$file/new") and (-d "$dir/$file/tmp")) {push @maildirs, "/$file"}
	}
	closedir (DIR);
	my $total = 0;
	my $class = "tdshade2_noborder";
	foreach my $line (@maildirs) {
		foreach my $subdir ("/cur","/new","/tmp") {
			opendir (DIR, "$dir$line$subdir");
			my @files = readdir(DIR);
			closedir (DIR);

			my $dirtot = 0;
			my $dirsize = 0;
			foreach my $file (sort @files) {
				if ((-f "$dir$line$subdir/$file") and ($file =~ /^(\d+)\./)) {
					if ("$line$subdir" ne $topdir) {
						$dirtot++;
						$dirsize += (stat("$dir$line$subdir/$file"))[7];
						next;
					}

					my $date = $1;

					my @mail;
					open (IN, "<$dir$line$subdir/$file");
					for (my $x = 0; $x < 200;$x++) {
						my $line  = <IN>;
						if ($line eq "\n") {last;}
						push (@mail, $line);
					}
					close (IN);
					chomp @mail;

					my @tmp = grep {$_ =~ /^subject:/i} @mail;
					my $subject;
					if ($tmp[0]) {$subject = $tmp[0]}
					if (length($subject) > 50) {$subject = substr($subject,0,47)."..."}
					$subject =~ s/subject://ig;
					$subject =~ s/>/&gt;/g;
					$subject =~ s/</&lt;/g;
					if ($subject =~ /^\s*$/) {$subject = "[no subject]"}

					($min, $hrs, $day, $month, $year) = (localtime($date)) [1,2,3,4,5];
					$date = sprintf("%04d-%02d-%02d %02d:%02d\n", $year+1900, $month+1, $day, $hrs, $min);

					my $size = int((stat("$dir$line$subdir/$file"))[7] / 1024);
					$total++;

					print "<tr class='$class'><td align='right'>$total</td>";
					print "<td align='center'><input type='checkbox' name='cmmdel_$total' value='$dir$line$subdir/$file'></td>";
					print "<td><u><a href=\"$script?action=viewmail&domain=$FORM{domain}&account=$FORM{account}&file=".&uri_escape($dir.$line.$subdir)."/$file\" target='_blank'>$subject</a></u></td><td>$date</td><td align='right'>$size KB</td>\n";
					print "<td><a href=\"$script?action=deletemail&domain=$FORM{domain}&account=$FORM{account}&file=".&uri_escape($dir.$line.$subdir)."/$file\" title='Delete Email' target='_blank'><img border='0' src='$images/delete.png'></a></td></tr>\n";
					if ($class eq "tdshade2_noborder") {$class = "tdshade1_noborder"} else {$class = "tdshade2_noborder"}
				}
			}
			if (($topdir eq "/") and ($dirtot > 0)) {
				my $showdir = "$line/$subdir";
				$showdir =~ s/\/+/\//g;
				my $emptydir = "<a href=\"$script?action=emptydir&domain=$FORM{domain}&account=$FORM{account}&file=".uri_escape($dir.$showdir)."\" title='Empty Directory' target='_blank' onClick='return confirmSubmit()'><img border='0' src='$images/empty.png'></a>";
				if ($mailscanner) {$emptydir .= " <a href=\"$script?action=salearn&domain=$FORM{domain}&account=$FORM{account}&file=".uri_escape($dir.$showdir)."\" title='Run SA Learn for spam' target='_blank'><img border='0' src='$images/sa.jpg'></a>"}
				$used = $dirsize / (1024 * 1024);
				if ($used == 0) {$emptydir = "&nbsp;"}
				$used = sprintf("%.02f",$used);
				print "<tr class='$class'><td>$emptydir</td><td>$showdir</td><td><u><a href=\"$script?action=view&domain=$FORM{domain}&account=$FORM{account}&topdir=".&uri_escape($line.$subdir)."&top=$FORM{top}\">View $dirtot emails</a></u></td><td colspan='3' align='right'>$used MB</td></tr>\n";
				if ($class eq "tdshade2_noborder") {$class = "tdshade1_noborder"} else {$class = "tdshade2_noborder"}
			}
		}
	}
	if ($topdir ne "/") {
		print "<tr class='$class'><td>&nbsp;</td><td align='center'><input type='checkbox' name='checkall' OnClick='checkme()'><br>All</td><td colspan='4'><input type='hidden' name='total' value='$total'><input type='submit' class='input' value='Delete Selected'></td></tr>\n";
		print "<tr class='$class'><td align='right'>&nbsp;</td><td>&nbsp;</td><td colspan='4'><input type='text' name='searchFor' /> - <input type='button' value='Select by search' onclick='javascript:selectSearch();' /></td></tr>\n";
		print "</table>\n";
		print "</form>";
		print "<p align='center'><form action='$script' method='post'><input type='hidden' name='domain' value='$FORM{domain}'><input type='hidden' name='account' value='$FORM{account}'><input type='hidden' name='top' value='$FORM{top}'><input type='hidden' name='action' value='view'><input type='submit' class='input' value='Go Back'></form></p>\n";
	} else {
		print "</table>\n";
	}
	print "<p align='center'><form action='$script' method='post'><input type='hidden' name='domain' value='$FORM{domain}'><input type='hidden' name='action' value='Manage Mail Accounts'><input type='submit' class='input' value='Return'></form></p>\n";
}
elsif ($FORM{action} eq "deletemail") {
	if (-f $FORM{file}) {
		my %userdomains;
		my $inlock = Cpanel::SafeFile::safeopen(\*IN,"<","/etc/userdomains");
		my @localusers = <IN>;
		Cpanel::SafeFile::safeclose(\*IN,$inlock);
		chomp @localusers;
		foreach my $line (@localusers) {
			my ($domain,$user) = split(/\: /,$line,2);
			$userdomains{$domain} = $user;
		}
		my ($file, $filedir) = fileparse($FORM{file});
		my $homedir = ( getpwnam($userdomains{$FORM{domain}}) )[7];
		if ($homedir eq "" or $filedir !~ /^$homedir/) {
			print "Invalid file [$FORM{file}]";
		} else {
			print "<p align='center'><u><b><a href='javascript: window.close()'>Close Window</a></b></u></p>\n";
			print "<table align='center' width='95%' border='0' cellspacing='0' cellpadding='4' bgcolor='#FFFFFF' style='border:1px solid #990000'>\n";
			print "<tr><th align='left'>Delete Email</th></tr>";
			unlink $FORM{file};
			my ($file, $filedir) = fileparse($FORM{file});
			if (-e "$filedir/../maildirsize") {unlink "$filedir/../maildirsize"}
			print "<tr class='tdshade2_noborder'><td>Email deleted</td></tr>\n";
			print "</table>\n";
			print "<script>window.opener.location.reload()</script>\n";
			print "<p align='center'><u><b><a href='javascript: window.close()'>Close Window</a></b></u></p>\n";
		}
	} else {
		print "File [$FORM{file}] not found";
	}
}
elsif ($FORM{action} eq "emptydir") {
	if (-d $FORM{file}) {
		my %userdomains;
		my $inlock = Cpanel::SafeFile::safeopen(\*IN,"<","/etc/userdomains");
		my @localusers = <IN>;
		Cpanel::SafeFile::safeclose(\*IN,$inlock);
		chomp @localusers;
		foreach my $line (@localusers) {
			my ($domain,$user) = split(/\: /,$line,2);
			$userdomains{$domain} = $user;
		}
		my ($file, $filedir) = fileparse($FORM{file});
		my $homedir = ( getpwnam($userdomains{$FORM{domain}}) )[7];
		if ($homedir eq "" or $filedir !~ /^$homedir/) {
			print "Invalid directory [$FORM{file}]";
		} else {
			my $total = 0;
			print "<p align='center'><u><b><a href='javascript: window.close()'>Close Window</a></b></u></p>\n";
			print "<table align='center' width='95%' border='0' cellspacing='0' cellpadding='4' bgcolor='#FFFFFF' style='border:1px solid #990000'>\n";
			print "<tr><th align='left'>Empty Directory [$FORM{file}]</th></tr>";
			print "<tr class='tdshade2_noborder'><td>";
			opendir (DIR, $FORM{file});
			while (my $file = readdir(DIR)) {
				if (readlink "$FORM{file}/$file") {next}
				if ((-f "$FORM{file}/$file") and ($file =~ /^\d+\./)) {
					print ". ";
					unlink ("$FORM{file}/$file");
					$total++;
				}
			}
			if (-e "$FORM{file}/../maildirsize") {unlink "$FORM{file}/../maildirsize"}
			closedir (DIR);
			print "<p>Total emails removed: $total</td></tr>\n";
			print "<tr class='tdshade1_noborder'><td>Directory emptied</td></tr>\n";
			print "</table>\n";
			print "<script>window.opener.location.reload()</script>\n";
		}
	} else {
		print "Directory [$FORM{file}] not found";
	}
	print "<p align='center'><u><b><a href='javascript: window.close()'>Close Window</a></b></u></p>\n";
}
elsif ($FORM{action} eq "salearn") {
	if (-d $FORM{file}) {
		my %userdomains;
		my $inlock = Cpanel::SafeFile::safeopen(\*IN,"<","/etc/userdomains");
		my @localusers = <IN>;
		Cpanel::SafeFile::safeclose(\*IN,$inlock);
		chomp @localusers;
		foreach my $line (@localusers) {
			my ($domain,$user) = split(/\: /,$line,2);
			$userdomains{$domain} = $user;
		}
		my ($file, $filedir) = fileparse($FORM{file});
		my $homedir = ( getpwnam($userdomains{$FORM{domain}}) )[7];
		if ($homedir eq "" or $filedir !~ /^$homedir/) {
			print "Invalid file [$FORM{file}]";
		} else {
			$| = 1;
			print "<p align='center'><u><b><a href='javascript: window.close()'>Close Window</a></b></u></p>\n";
			print "<table align='center' width='95%' border='0' cellspacing='0' cellpadding='4' bgcolor='#FFFFFF' style='border:1px solid #990000'>\n";
			print "<tr><th align='left'>Running sa-learn for spam against [$FORM{file}]</th></tr>";
			print "<tr class='tdshade2_noborder'><td><p>This may take some time depending on the number of emails and the speed of SpamAssassin:</p>\n<pre>\n\# /usr/local/cpanel/3rdparty/bin/sa-learn --spam --showdots $FORM{file}\n";
			my ($childin, $childout);
			my $cmdpid = open3($childin, $childout, $childout, "/usr/local/cpanel/3rdparty/bin/sa-learn", "--spam", "--showdots", $FORM{file});
			while (<$childout>) {print $_}
			waitpid ($cmdpid, 0);
			print "</pre>\n</td></tr>\n";
			print "</table>\n";
			print "<script>window.opener.location.reload()</script>\n";
		}
	} else {
		print "File [$FORM{file}] not found";
	}
	print "<p align='center'><u><b><a href='javascript: window.close()'>Close Window</a></b></u></p>\n";
}
elsif ($FORM{action} eq "bulkdelete") {
	my $total = 0;
	my $anyfile;
	my %userdomains;
	my $inlock = Cpanel::SafeFile::safeopen(\*IN,"<","/etc/userdomains");
	my @localusers = <IN>;
	Cpanel::SafeFile::safeclose(\*IN,$inlock);
	chomp @localusers;
	foreach my $line (@localusers) {
		my ($domain,$user) = split(/\: /,$line,2);
		$userdomains{$domain} = $user;
	}
	print "<table align='center' width='95%' border='0' cellspacing='0' cellpadding='4' bgcolor='#FFFFFF' style='border:1px solid #990000'>\n";
	print "<tr><th align='left'>Delete Selected Mails</th></tr>";
	print "<tr class='tdshade2_noborder'><td>";
	for ($x = 1; $x <= $FORM{total} ;$x++) {
		my $delfile = $FORM{"cmmdel_$x"};
		if (-f $delfile) {
			my ($file, $filedir) = fileparse($delfile);
			my $homedir = ( getpwnam($userdomains{$FORM{domain}}) )[7];
			if ($homedir eq "" or $filedir !~ /^$homedir/) {
				print "Invalid file [$delfile]";
			} else {
				unlink ($delfile);
				$total++;
				$anyfile = $delfile;
			}
		}
	}
	my ($file, $filedir) = fileparse($anyfile);
	if (-d $filedir) {
		my $homedir = ( getpwnam($userdomains{$FORM{domain}}) )[7];
		if ($homedir eq "" or $filedir !~ /^$homedir/) {
			print "Invalid directory [$filedir]";
		} else {
			if (-e "$filedir/../maildirsize") {unlink "$filedir/../maildirsize"}
		}
	}
	print "<p>Total emails removed: $total</td></tr>\n";
	print "</table>\n";
	print "<p align='center'><form action='$script' method='post'><input type='hidden' name='top' value='$FORM{top}'><input type='hidden' name='domain' value='$FORM{domain}'><input type='hidden' name='account' value='$FORM{account}'><input type='hidden' name='topdir' value='$FORM{topdir}'><input type='hidden' name='action' value='view'><input type='submit' class='input' value='Go Back'></form></p>\n";
}
elsif ($FORM{action} eq "changequota") {
	my %userdomains;
	my $inlock = Cpanel::SafeFile::safeopen(\*IN,"<","/etc/userdomains");
	my @localusers = <IN>;
	Cpanel::SafeFile::safeclose(\*IN,$inlock);
	chomp @localusers;
	foreach my $line (@localusers) {
		my ($domain,$user) = split(/\: /,$line,2);
		$userdomains{$domain} = $user;
	}

	if (($FORM{quota} =~ /[^\d\.]/) or ($FORM{quota} == 0)) {$FORM{quota} = "unlimited"}

	print "<table align='center' width='95%' border='0' cellspacing='0' cellpadding='4' bgcolor='#FFFFFF' style='border:1px solid #990000'>\n";
	print "<tr><th align='left'>Change Quota for $FORM{account}\@$FORM{domain}</th></tr>";
	print "<tr class='tdshade2_noborder'><td align='center'>";
	&drop($userdomains{$FORM{domain}});
	my ($childin, $childout);
	my $cmdpid = open3($childin, $childout, $childout, "/usr/local/cpanel/cpanel-email", "editquota", $FORM{account}, $FORM{domain}, $FORM{quota});
	my @data = <$childout>;
	waitpid ($cmdpid, 0);
	chomp @data;
	my $cnt = 0;
	foreach my $line (@data) {
		if ($line =~ /^stdin: is not a tty/) {next}
		print "<p>$line</p>\n";
		$cnt++;
	}
	unless ($cnt) {print "<p>Quota changed to $FORM{quota} MB</p>\n"}
	print "</td></tr>\n";

	print "</table>\n";
	print "<p align='center'><form action='$script' method='post'><input type='hidden' name='domain' value='$FORM{domain}'><input type='hidden' name='action' value='Manage Mail Accounts'><input type='submit' class='input' value='Return'></form></p>\n";
}
elsif ($FORM{action} eq "password") {
	print "<form action='$script' method='post'>\n";
	print "<table align='center' width='95%' border='0' cellspacing='0' cellpadding='4' bgcolor='#FFFFFF' style='border:1px solid #990000'>\n";
	print "<tr><th align='left' colspan='2'>Change Password for $FORM{account}\@$FORM{domain}</th></tr>";
	print "<tr class='tdshade2_noborder'><td><input type='password' size=20 name='password'> New password</td></tr>\n";
	print "<tr class='tdshade1_noborder'><td><input type='password' size=20 name='confirmpassword'> Confirm password</td></tr>\n";
	print "<tr class='tdshade2_noborder' align='center'><td colspan='2'><input type='submit' class='input' name='action' value='Change Password'></td></tr>\n";
	print "</table>\n";
	print "<input type='hidden' name='account' value='$FORM{account}'><input type='hidden' name='domain' value='$FORM{domain}'></form>\n";
	print "<p align='center'><form action='$script' method='post'><input type='hidden' name='domain' value='$FORM{domain}'><input type='hidden' name='action' value='Manage Mail Accounts'><input type='submit' class='input' value='Return'></form></p>\n";
}
elsif ($FORM{action} eq "Change Password") {
	my %userdomains;
	my $inlock = Cpanel::SafeFile::safeopen(\*IN,"<","/etc/userdomains");
	my @localusers = <IN>;
	Cpanel::SafeFile::safeclose(\*IN,$inlock);
	chomp @localusers;
	foreach my $line (@localusers) {
		my ($domain,$user) = split(/\: /,$line,2);
		$userdomains{$domain} = $user;
	}

	print "<table align='center' width='95%' border='0' cellspacing='0' cellpadding='4' bgcolor='#FFFFFF' style='border:1px solid #990000'>\n";
	print "<tr><th align='left' colspan='2'>Change Password for $FORM{account}\@$FORM{domain}</th></tr>";
	if ($FORM{password} eq "") {
		print "<tr class='tdshade2_noborder'><td align='center'>Failed: Empty password field</td></tr>\n";
	}
	elsif ($FORM{password} ne $FORM{confirmpassword}) {
		print "<tr class='tdshade2_noborder'><td align='center'>Failed: Passwords do not match</td></tr>\n";
	}
	elsif ($FORM{password} =~ /\"/) {
		print "<tr class='tdshade2_noborder'><td align='center'>Failed: password must not contain quotes</td></tr>\n";
	}
	else {
		print "<tr class='tdshade2_noborder'><td align='center'>\n";
		&drop($userdomains{$FORM{domain}});
		my ($childin, $childout);
		my $cmdpid = open3($childin, $childout, $childout, "/usr/local/cpanel/cpanel-email", "passwdpop", $FORM{account}, "$FORM{password}", "0", $FORM{domain});
		my @data = <$childout>;
		waitpid ($cmdpid, 0);
		chomp @data;
		my $cnt = 0;
		foreach my $line (@data) {
			if ($line =~ /^stdin: is not a tty/) {next}
			print "<p>$line</p>\n";
			$cnt++;
		}
		unless ($cnt) {print "<p>Password changed</p>\n"}
	}
	print "</table>\n";
	print "<p align='center'><form action='javascript:history.go(-1)' method='post'><input type='submit' class='input' value='Go Back'></form></p>\n";
	print "<p align='center'><form action='$script' method='post'><input type='hidden' name='domain' value='$FORM{domain}'><input type='hidden' name='action' value='Manage Mail Accounts'><input type='submit' class='input' value='Return'></form></p>\n";
}
elsif ($FORM{action} eq "delete") {
	print "<form action='$script' method='post'>\n";
	print "<table align='center' width='95%' border='0' cellspacing='0' cellpadding='4' bgcolor='#FFFFFF' style='border:1px solid #990000'>\n";
	print "<tr><th align='left' colspan='2'>Delete Mailbox $FORM{account}\@$FORM{domain}</th></tr>";
	print "<tr class='tdshade2_noborder'><td><b>Are you sure that you want to delete this mailbox and all of the email within it?</b></td></tr>\n";
	print "<tr class='tdshade1_noborder' align='center'><td colspan='2'><input type='submit' class='input' name='action' value='Delete Mailbox'></td></tr>\n";
	print "</table>\n";
	print "<input type='hidden' name='account' value='$FORM{account}'><input type='hidden' name='domain' value='$FORM{domain}'></form>\n";
	print "<p align='center'><form action='$script' method='post'><input type='hidden' name='domain' value='$FORM{domain}'><input type='hidden' name='action' value='Manage Mail Accounts'><input type='submit' class='input' value='Return'></form></p>\n";
}
elsif ($FORM{action} eq "Delete Mailbox") {
	my %userdomains;
	my $inlock = Cpanel::SafeFile::safeopen(\*IN,"<","/etc/userdomains");
	my @localusers = <IN>;
	Cpanel::SafeFile::safeclose(\*IN,$inlock);
	chomp @localusers;
	foreach my $line (@localusers) {
		my ($domain,$user) = split(/\: /,$line,2);
		$userdomains{$domain} = $user;
	}

	print "<table align='center' width='95%' border='0' cellspacing='0' cellpadding='4' bgcolor='#FFFFFF' style='border:1px solid #990000'>\n";
	print "<tr><th align='left'>Delete Mailbox $FORM{account}\@$FORM{domain}</th></tr>";
	print "<tr class='tdshade2_noborder'><td align='center'>\n";
	&drop($userdomains{$FORM{domain}});
	my ($childin, $childout);
	my $cmdpid = open3($childin, $childout, $childout, "/usr/local/cpanel/cpanel-email", "delpop", $FORM{account}, "0", $FORM{domain});
	my @data = <$childout>;
	waitpid ($cmdpid, 0);
	chomp @data;
	my $cnt = 0;
	foreach my $line (@data) {
		if ($line =~ /^stdin: is not a tty/) {next}
		print "<p>$line</p>\n";
		$cnt++;
	}
	print "<p>Account deleted</p>\n";
	print "</table>\n";
	print "<p align='center'><form action='$script' method='post'><input type='hidden' name='domain' value='$FORM{domain}'><input type='hidden' name='action' value='Manage Mail Accounts'><input type='submit' class='input' value='Return'></form></p>\n";
}
elsif ($FORM{action} eq "Add Mailbox") {
	my %userdomains;
	my $inlock = Cpanel::SafeFile::safeopen(\*IN,"<","/etc/userdomains");
	my @localusers = <IN>;
	Cpanel::SafeFile::safeclose(\*IN,$inlock);
	chomp @localusers;
	foreach my $line (@localusers) {
		my ($domain,$user) = split(/\: /,$line,2);
		$userdomains{$domain} = $user;
	}

	if (($FORM{quota} =~ /[^\d\.]/) or ($FORM{quota} == 0)) {$FORM{quota} = "unlimited"}

	print "<table align='center' width='95%' border='0' cellspacing='0' cellpadding='4' bgcolor='#FFFFFF' style='border:1px solid #990000'>\n";
	print "<tr><th align='left'>Add Mailbox $FORM{account}\@$FORM{domain}</th></tr>";
	if ($FORM{password} eq "") {
		print "<tr class='tdshade2_noborder'><td align='center'>Failed: Empty password field</td></tr>\n";
	}
	elsif ($FORM{password} ne $FORM{confirmpassword}) {
		print "<tr class='tdshade2_noborder'><td align='center'>Failed: Passwords do not match</td></tr>\n";
	}
	elsif ($FORM{password} =~ /\"/) {
		print "<tr class='tdshade2_noborder'><td align='center'>Failed: password must not contain quotes</td></tr>\n";
	}
	else {
		print "<tr class='tdshade2_noborder'><td align='center'>\n";
		&drop($userdomains{$FORM{domain}});
		my ($childin, $childout);
		my $cmdpid = open3($childin, $childout, $childout, "/usr/local/cpanel/cpanel-email", "addpop", $FORM{account}, "$FORM{password}", $FORM{quota}, $FORM{domain});
		my @data = <$childout>;
		waitpid ($cmdpid, 0);
		chomp @data;
		my $cnt = 0;
		foreach my $line (@data) {
			if ($line =~ /^stdin: is not a tty/) {next}
			print "<p>$line</p>\n";
			$cnt++;
		}
		print "<p>Account created</p>\n";
		print "</td></tr>\n";
	}
	print "</table>\n";
	print "<p align='center'><form action='$script' method='post'><input type='hidden' name='domain' value='$FORM{domain}'><input type='hidden' name='action' value='Manage Mail Accounts'><input type='submit' class='input' value='Return'></form></p>\n";
}
elsif (($FORM{action} =~ /^Mail Quota Report \((.*)\)/) or ($FORM{action} eq "Manage Mail Accounts")) {
	my $report = $1;
	my $total = 0;
	my $colspan = 5;
	my $extracol = "<th>&nbsp;</th>";
	my ($tot_accounts, $tot_mails, $tot_space);

	if ($FORM{action} eq "Manage Mail Accounts") {
		$FORM{dospace} = 0;
		$FORM{dopercent} = 1;
		$FORM{percent} = 99;
		$FORM{doall} = 1;
		$report = "Selected";
		$colspan = 5;
		$extracol = "<th>Action</th>";
		print "<br><div align='center'><form action='$script' method='post'><input type='hidden' name='domain' value='$FORM{domain}'><input type='submit' class='input' name='action' value='Manage Mail Forwarders'>&nbsp;&nbsp;<input type='submit' class='input' name='action' value='Manage Mail Filters'>&nbsp;&nbsp;<input type='submit' class='input' name='action' value='Manage Mail Hourly Limits'></form></div>\n";
	}

	print "<table align='center' width='95%' border='0' cellspacing='0' cellpadding='4' bgcolor='#FFFFFF' style='border:1px solid #990000'>\n";
	print "<tr><th align='left' colspan='$colspan'>Mail Account Quotas</th></tr>";
	print "<tr><th align='left'>Account</th><th>Mails</th><th>Used (MB)</th><th>Quota (MB)</th>$extracol</tr>";

	my @users;
	my %userdomains;
	my $inlock = Cpanel::SafeFile::safeopen(\*IN,"<","/etc/userdomains");
	my @localusers = <IN>;
	Cpanel::SafeFile::safeclose(\*IN,$inlock);
	chomp @localusers;
	foreach my $line (@localusers) {
		my ($domain,$user) = split(/\: /,$line,2);
		$userdomains{$domain} = $user;
	}

	my @domains;
	if ($report eq "Selected") {
		push @domains, $FORM{domain};
	} else {
		my $inlock = Cpanel::SafeFile::safeopen(\*IN,"<","/etc/userdomains");
		while (my $entry = <IN>) {
			chomp $entry;
			my ($domain,$user) = split(/:\s*/,$entry);
			if ($user eq "nobody") {next}
			push @domains, $domain;
		}
		Cpanel::SafeFile::safeclose(\*IN,$inlock);
		@domains = sort @domains;
	}

	my $class = "tdshade2_noborder";
	foreach my $domain (@domains) {
		unless ($domain) {next}
		if ($domain =~ /^\#/) {next}
        my $homedir = ( getpwnam($userdomains{$domain}) )[7];
		unless (-e "$homedir/etc/$domain/passwd") {next}
		unless (-e "$homedir/etc/$domain/quota") {next}

		my @accounts;
		my $inlock = Cpanel::SafeFile::safeopen(\*IN,"+<","$homedir/etc/$domain/passwd");
		my @localusers = <IN>;
		Cpanel::SafeFile::safeclose(\*IN,$inlock);
		chomp @localusers;
		foreach my $line (@localusers) {
			($user,undef) = split(/\:/,$line,2);
			if ($user) {push @accounts,$user}
		}
		@accounts = sort @accounts;
		unshift @accounts,$userdomains{$domain};

		$inlock = Cpanel::SafeFile::safeopen(\*IN,"+<","$homedir/etc/$domain/quota");
		my @localquota = <IN>;
		Cpanel::SafeFile::safeclose(\*IN,$inlock);
		chomp @localquota;

		my %quotas;
		foreach my $line (@localquota) {
			my ($user,$quota) = split(/\:/,$line,2);
			$quotas{$user} = $quota;
		}

		my $first = 1;
		my $lines = 0;
		foreach my $key (@accounts) {
			my $dir;
			my $topdomain = "\@$domain";
			my $quota = $quotas{$key};
			if ($first == -1) {$first = 0}
			if ($first) {
				$class = "tdshade2_noborder";
				$first = -1;
				my $inlock = Cpanel::SafeFile::safeopen(\*IN,"<","/var/cpanel/users/$userdomains{$domain}");
				my @userdata = <IN>;
				Cpanel::SafeFile::safeclose(\*IN,$inlock);
				chomp @userdata;
				my $maindomain;
				foreach my $line (@userdata) {
					if ($line =~ /^DNS=(.*)/) {$maindomain = $1}
				}
				if ($maindomain ne $domain) {next}
				$dir = "$homedir/mail";
				$topdomain = " (<b>$domain</b> cPanel user)";
				$quota = 0;
			} else {
				$dir = "$homedir/mail/$domain/$key";
			}

			my @maildirs;
			push @maildirs, $dir;
			opendir (DIR, $dir);
			while (my $file = readdir(DIR)) {
				if ($file eq ".") {next}
				if ($file eq "..") {next}
				if (readlink "$dir/$file") {next}
				if ((-d "$dir/$file") and (-d "$dir/$file/cur") and (-d "$dir/$file/new") and (-d "$dir/$file/tmp")) {push @maildirs, "$dir/$file"}
			}
			closedir (DIR);
			my $used = 0;
			my $files = 0;
			foreach my $line (@maildirs) {
				foreach my $subdir ("/","/cur","/new","/tmp") {
					opendir (DIR, "$line$subdir");
					while (my $file = readdir(DIR)) {
						if ((-f "$line$subdir/$file") and ($file =~ /^\d+\./)) {
							$used += (stat("$line$subdir/$file"))[7];
							$files++;
						}
					}
					closedir (DIR);
				}
			}

			my $uclass = $class;
			if (($FORM{dospace}) and ($used > $FORM{space} * 1024 * 1024)) {$uclass = "tdshadeyellow"}
			if (($FORM{dopercent}) and (($used >= $quota) or ($used / $quota >= ($FORM{percent} / 100))) and ($quota > 0)) {$uclass = "tdshadered"}

			unless ($FORM{doall}) {
				if ($uclass eq "tdshade1_noborder") {next}
				if ($uclass eq "tdshade2_noborder") {next}
			}
			my $uquota = 0;
			if ($quota > 0) {$uquota = int(($used / $quota) * 100)}

			$used = $used / (1024 * 1024);

			my $tused = $used;
			$used = sprintf("%.02f",$used);

			$used .= " ($uquota\%)";

			if ($quota < 1) {
				$quota = "unlimited";
			} else {
				$quota = int($quota / (1024 * 1024));
			}
			
			if ($FORM{action} eq "Manage Mail Accounts") {
				$tot_accounts++;
				$tot_mails+=$files;
				$tot_space+=$tused;
				print "<tr class='$uclass'><form action='$script' method='post'><td>$key$topdomain</td><td align='right'>$files</td><td align='right'>$used</td><td align='right'>";
				if ($first == -1) {
					print "$quota</td><td>";
					if ($files > 0) {
						print " <a href='$script?action=view&account=$key&domain=$domain&top=1' title='View MailBox Contents'><img border='0' src='$images/view.png'></a>&nbsp;&nbsp;&nbsp;&nbsp;";
						print " <a href='$script?action=empty&account=$key&domain=$domain&top=1' title='Empty Mailbox'><img border='0' src='$images/empty.png'></a>";
					}
				} else {
					print "<input type='text' size='10' name='quota' value='$quota' style='text-align: right; padding-right: 2px'><input type='hidden' name='domain' value='$domain'><input type='hidden' name='account' value='$key'><input type='hidden' name='action' value='changequota'></td><td><input type='image' title='Change Quota' src='$images/quota.png' style='border: none'>";
					print " <a href='$script?action=password&domain=$domain&account=$key' title='Change Mailbox Password'><img border='0' src='$images/password.png'></a>";
					if ($files > 0) {
						print " <a href='$script?action=view&account=$key&domain=$domain' title='View MailBox Contents'><img border='0' src='$images/view.png'></a>&nbsp;&nbsp;&nbsp;&nbsp;";
						print " <a href='$script?action=empty&account=$key&domain=$domain' title='Empty Mailbox'><img border='0' src='$images/empty.png'></a>";
					} else {print "&nbsp;&nbsp;&nbsp;&nbsp;";}
					print " <a href='$script?action=delete&domain=$domain&account=$key' title='Delete Mailbox'><img border='0' src='$images/delete.png'></a>";
				}
				print "</td></form></tr>\n";
			} else {
				print "<tr class='$uclass'><td>$key$topdomain</td><td align='right'>$files</td><td align='right'>$used</td><td align='right'>$quota</td><td>\n";
				print " <a href='$script?action=Manage\%20Mail\%20Accounts&account=$key&domain=$domain&space=$FORM{space}&percent=$FORM{percent}' title='Manage Mail Accounts'><img border='0' src='$images/manage.png'></a></td></tr>\n";
			}

			if ($class eq "tdshade2_noborder") {$class = "tdshade1_noborder"} else {$class = "tdshade2_noborder"}
			$total++;
			$lines++;
		}
		my $info = "<th colspan='$colspan'>&nbsp;</th>";
		$tot_space = sprintf("%.02f",$tot_space);
		if ($FORM{action} eq "Manage Mail Accounts") {$info = "<th align='left'>$tot_accounts account(s)</th><th align='right'>$tot_mails</th><th align='right'>$tot_space</th><th colspan='2'>&nbsp;</th>"}
		if ($FORM{doall} and $lines) {print "<tr>$info</tr>\n"}
	}
	print "</table>\n";
	if ($FORM{action} eq "Manage Mail Accounts") {
		print "<table border='0' cellpadding='4' cellspacing='0' align='center'>\n";
		print "<tr><td valign='top'>\n";
		print "<table align='center' width='95%' border='0' cellspacing='0' cellpadding='4' bgcolor='#FFFFFF' style='border:1px solid #990000'>\n";
		print "<form action='$script' method='post'><input type='hidden' name='domain' value='$FORM{domain}'>\n";
		print "<tr><th align='left' colspan='2'>Add Mailbox</th></tr>";
		my ($childin, $childout);
		my $cmdpid = open3($childin, $childout, $childout, "/usr/bin/quota", "-qlu", $userdomains{$FORM{domain}});
		my @data = <$childout>;
		waitpid ($cmdpid, 0);
		chomp @data;
		if ($data[0] =~ /Block limit reached/) {
			print "<tr class='scellheader' align='center'><td colspan='2'><p>cPanel account over quota - add mailbox disabled</p></td></tr>\n";
		} else {
			print "<tr class='tdshade2_noborder'><td>Account</td><td><input type='text' size='10' name='account'>\@$FORM{domain}</td></tr>\n";
			print "<tr class='tdshade1_noborder'><td>Password</td><td><input type='password' size='10' name='password'></td></tr>\n";
			print "<tr class='tdshade2_noborder'><td>Confirm</td><td><input type='password' size='10' name='confirmpassword'></td></tr>\n";
			print "<tr class='tdshade1_noborder'><td>Quota</td><td><input type='text' size='10' name='quota' value='10'>MB</td></tr>\n";
			print "<tr class='tdshade2_noborder' align='center'><td colspan='2'><input type='submit' class='input' name='action' value='Add Mailbox'></td></tr>\n";
		}
		print "</form></table>\n";
		print "</td><td>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</td><td valign='top'>\n";
		print "<table align='center' width='95%' border='0' cellspacing='0' cellpadding='4' bgcolor='#FFFFFF' style='border:1px solid #990000'>\n";
		print "<tr><th align='left' colspan='2'>Button Key</th></tr>";
		print "<tr class='tdshade2_noborder'><td><img border='0' src='$images/quota.png'></td><td>Change mailbox quota</td></tr>\n";
		print "<tr class='tdshade1_noborder'><td><img border='0' src='$images/password.png'></td><td>Change mailbox password</td></tr>\n";
		print "<tr class='tdshade2_noborder'><td><img border='0' src='$images/view.png'></td><td>View mailbox contents</td></tr>\n";
		print "<tr class='tdshade1_noborder'><td><img border='0' src='$images/empty.png'></td><td>Empty mailbox/Directory</td></tr>\n";
		print "<tr class='tdshade2_noborder'><td><img border='0' src='$images/delete.png'></td><td>Delete mailbox/Mail</td></tr>\n";
		if ($mailscanner) {print "<tr class='tdshade1_noborder'><td><img border='0' src='$images/sa.jpg'></td><td>sa-learn spam Directory</td></tr>\n"}
		print "</table>\n";
		print "</td></tr></table>\n";
	}
	print "<p>Total Accounts: $total</p>\n";
	print "<p align='center'><form action='$script' method='post'><input type='submit' class='input' value='Return'></form></p>\n";
}
elsif ($FORM{action} eq "Bulk Enable GreyListing") {
	require Cpanel::GreyList::Client;

	print "<table align='center' width='95%' border='0' cellspacing='0' cellpadding='4' bgcolor='#FFFFFF' style='border:1px solid #990000'>\n";
	print "<tr><td>Enabled GreyListing on all domains</td></tr>\n";
	print "</table>\n";
	my @localdomains;
	my $inlock = Cpanel::SafeFile::safeopen(\*IN,"<","/etc/userdomains");
	while (my $entry = <IN>) {
		chomp $entry;
		my ($domain,$user) = split(/:\s*/,$entry);
		if ($user eq "nobody") {next}
		if ($domain eq "") {next}
		if ($domain eq "*") {next}
		push @localdomains, $domain;
	}
	my $client = Cpanel::GreyList::Client->new();
	$client->disable_opt_out_for_domains(\@localdomains);
	print "<p align='center'><form action='$script' method='post'><input type='submit' class='input' value='Return'></form></p>\n";
}
elsif ($FORM{action} eq "Bulk Show GreyListing") {
	require Cpanel::GreyList::Client;

	print "<table align='center' width='95%' border='0' cellspacing='0' cellpadding='4' bgcolor='#FFFFFF' style='border:1px solid #990000'>\n";
	my @localdomains;
	my $inlock = Cpanel::SafeFile::safeopen(\*IN,"<","/etc/userdomains");
	while (my $entry = <IN>) {
		chomp $entry;
		my ($domain,$user) = split(/:\s*/,$entry);
		if ($user eq "nobody") {next}
		if ($domain eq "") {next}
		if ($domain eq "*") {next}
		my $client = Cpanel::GreyList::Client->new();
		if ($client->is_greylisting_enabled($domain)) {
			print "<tr><td>GreyListing is <b>enabled</b> for $domain</td></tr>\n";
		} else {
			print "<tr><td>GreyListing is disabled for $domain</td></tr>\n";
		}
	}
	print "</table>\n";
	print "<p align='center'><form action='$script' method='post'><input type='submit' class='input' value='Return'></form></p>\n";
}
elsif ($FORM{action} eq "Bulk Disable GreyListing") {
	require Cpanel::GreyList::Client;

	print "<table align='center' width='95%' border='0' cellspacing='0' cellpadding='4' bgcolor='#FFFFFF' style='border:1px solid #990000'>\n";
	print "<tr><td>Disabled GreyListing on all domains</td></tr>\n";
	print "</table>\n";
	my @localdomains;
	my $inlock = Cpanel::SafeFile::safeopen(\*IN,"<","/etc/userdomains");
	while (my $entry = <IN>) {
		chomp $entry;
		my ($domain,$user) = split(/:\s*/,$entry);
		if ($user eq "nobody") {next}
		if ($domain eq "") {next}
		if ($domain eq "*") {next}
		push @localdomains, $domain;
	}
	my $client = Cpanel::GreyList::Client->new();
	$client->enable_opt_out_for_domains(\@localdomains);
	print "<p align='center'><form action='$script' method='post'><input type='submit' class='input' value='Return'></form></p>\n";
}
elsif ($FORM{action} eq "Show GreyListing") {
	unless ($FORM{domain}) {
		print "<p>You must select a domain!</p>\n";
	} else {
		require Cpanel::GreyList::Client;

		print "<table align='center' width='95%' border='0' cellspacing='0' cellpadding='4' bgcolor='#FFFFFF' style='border:1px solid #990000'>\n";
		my $client = Cpanel::GreyList::Client->new();
		if ($client->is_greylisting_enabled($FORM{domain})) {
			print "<tr><td>GreyListing is <b>enabled</b> for $FORM{domain}</td></tr>\n";
		} else {
			print "<tr><td>GreyListing is disabled for $FORM{domain}</td></tr>\n";
		}
		print "</table>\n";
	}
	print "<p align='center'><form action='$script' method='post'><input type='submit' class='input' value='Return'></form></p>\n";
}
elsif ($FORM{action} eq "Enable GreyListing") {
	unless ($FORM{domain}) {
		print "<p>You must select a domain!</p>\n";
	} else {
		require Cpanel::GreyList::Client;

		print "<table align='center' width='95%' border='0' cellspacing='0' cellpadding='4' bgcolor='#FFFFFF' style='border:1px solid #990000'>\n";
		print "<tr><td>Enabled GreyListing on $FORM{domain}</td></tr>\n";
		print "</table>\n";
		my %domains;
		my @domains;
		my $client = Cpanel::GreyList::Client->new();
		@domains = ($FORM{domain});
		$client->disable_opt_out_for_domains(\@domains);
	}
	print "<p align='center'><form action='$script' method='post'><input type='submit' class='input' value='Return'></form></p>\n";
}
elsif ($FORM{action} eq "Disable GreyListing") {
	unless ($FORM{domain}) {
		print "<p>You must select a domain!</p>\n";
	} else {
		require Cpanel::GreyList::Client;

		print "<table align='center' width='95%' border='0' cellspacing='0' cellpadding='4' bgcolor='#FFFFFF' style='border:1px solid #990000'>\n";
		print "<tr><td>Disabled GreyListing on $FORM{domain}</td></tr>\n";
		print "</table>\n";
		my %domains;
		my @domains;
		my $client = Cpanel::GreyList::Client->new();
		@domains = ($FORM{domain});
		$client->enable_opt_out_for_domains(\@domains);
	}
	print "<p align='center'><form action='$script' method='post'><input type='submit' class='input' value='Return'></form></p>\n";
}
elsif ($FORM{action} eq "upgrade") {
	$| = 1;

	print "<pre style='font-family: Courier New, Courier; font-size: 12px'>";

	if (-e "/usr/src/cmm.tgz") {unlink ("/usr/src/cmm.tgz") or die $!}
	print "Retrieving new cmm package...\n";

	my ($status, $text) = &urlget("https://download.configserver.com/cmm.tgz","/usr/src/cmm.tgz");
	if ($status) {print "Oops: $text\n"}

	if (! -z "/usr/src/cmm.tgz") {
		print "Unpacking new cmm package...\n";
		print "<pre style='font-family: Courier New, Courier; font-size: 12px'>";
		system ("cd /usr/src ; tar -xzf cmm.tgz ; cd cmm ; sh install.sh 2>&1");
		print "</pre>";
		print "Tidying up...\n";
		print "<pre style='font-family: Courier New, Courier; font-size: 12px'>";
		system ("rm -Rfv /usr/src/cmm*");
		print "</pre>";
		print "...All done.\n";
	}
	print "</pre>";

	open (IN, "<$versionfile") or die $!;
	$myv = <IN>;
	close (IN);
	chomp $myv;

	print "<p align='center'><form action='$script' method='post'><input type='submit' class='input' value='Return'></form></p>\n";
}
else {
	my $inlock = Cpanel::SafeFile::safeopen(\*IN,"<","/etc/userdomains");
	while (my $entry = <IN>) {
		chomp $entry;
		my ($domain,$user) = split(/:\s*/,$entry);
		if ($user eq "nobody") {next}
		push @localdomains, $domain;
	}
	Cpanel::SafeFile::safeclose(\*IN,$inlock);
	@localdomains = sort @localdomains;

	my $domainlist;
	my $domaincnt;
	foreach my $domain (@localdomains) {
		$domainlist .= "<option>$domain</option>\n";
		$domaincnt ++;
	}

	print "<form action='$script' method='post'>\n";
	print "<table align='center' width='95%' border='0' cellspacing='0' cellpadding='4' bgcolor='#FFFFFF' style='border:1px solid #990000'>\n";
	print "<tr><th align='left' colspan='2'>Mail Manage</th></tr>";
	print "<tr class='tdshade2_noborder'><td valign='top'><select name='domain' size='20'>$domainlist\n";
	print "</td><td valign='top'>\n";
	print "<p><input type='submit' class='input' name='action' value='Manage Mail Accounts'></p>\n";
	print "<p><input type='submit' class='input' name='action' value='Manage Mail Forwarders'></p>\n";
	print "<p><input type='submit' class='input' name='action' value='Manage Mail Filters'></p>\n";
	print "<p><input type='submit' class='input' name='action' value='Manage Mail Hourly Limits'></p>\n";
	if (-e "/var/cpanel/greylist/enabled") {
		print "<p><input type='submit' class='input' name='action' value='Show GreyListing'></p>\n";
		print "<p><input type='submit' class='input' name='action' value='Enable GreyListing'></p>\n";
		print "<p><input type='submit' class='input' name='action' value='Disable GreyListing'> WARNING: If you disable GreyListing on a main domain cPanel forces all subdomains to be disabled until the main domain is enabled</p>\n";
	}
	print "<p>Mail Domains: $domaincnt</p>\n";
	print "</td></tr>\n";

	print "<tr><th align='left' colspan='2'>Mail Reports</th></tr>";
	print "<tr class='tdshade2_noborder'><td colspan='2'>\n";
	print "<input type='checkbox' name='dospace' value='1' checked> Identify accounts using over <input type='text' size='3' value='10' name='space'>MB of mailbox space<br>\n";
	print "<input type='checkbox' name='dopercent' value='1' checked> Identify accounts using within or over <input type='text' size='3' value='99' name='percent'>% of the mailbox quota<br>\n";
	print "<input type='checkbox' name='doall' value='1' checked> Show all accounts\n";
	print "<p>Note: These reports may take some time to run</p></td></tr>\n";
	print "<tr class='tdshade1_noborder'><td><input type='submit' class='input' name='action' value='Mail Quota Report (Selected)'></td><td>View email account usage for the domain selected above</td></tr>\n";
	print "<tr class='tdshade2_noborder'><td><input type='submit' class='input' name='action' value='Mail Quota Report (All)'></td><td>View email account usage for all domains</td></tr>\n";
	print "<tr class='tdshade1_noborder'><td><input type='reset' class='input' name='action' value='Reset Form'></td><td>&nbsp;</td></tr>\n";

	print "</table><br />\n";

	if (-e "/var/cpanel/greylist/enabled") {
		print "<table align='center' width='95%' border='0' cellspacing='0' cellpadding='4' bgcolor='#FFFFFF' style='border:1px solid #990000'>\n";
		print "<tr><th align='left' colspan='2'>GreyListing</th></tr>";
		print "<tr class='tdshade2_noborder'><td colspan='2'><b><font color='red'>WARNING:</font> Using GreyListing can and will lead to lost legitimate emails. It can also cause significant problems with \"password verification\" systems.</b><br>\nSee <a href='https://en.wikipedia.org/wiki/Greylisting#Disadvantages' target='_blank'>here</a> for more information</td></tr>\n";
		print "<tr class='tdshade1_noborder'><td><input type='submit' class='input' name='action' value='Bulk Show GreyListing'></td><td>Display GreyListing for all domains</td></tr>\n";
		print "<tr class='tdshade2_noborder'><td><input type='submit' class='input' name='action' value='Bulk Enable GreyListing'></td><td>Configure GreyListing so that all domains are disabled</td></tr>\n";
		print "<tr class='tdshade1_noborder'><td><input type='submit' class='input' name='action' value='Bulk Disable GreyListing'></td><td>Configure GreyListing so that all domains are enabled</td></tr>\n";
		print "</table><br />\n";
	}

	my $retry = 0;
	my $retrytime = 300;
	print "<table align='center' width='95%' border='0' cellspacing='0' cellpadding='4' bgcolor='#FFFFFF' style='border:1px solid #990000'>\n";
	print "<tr><th align='left' colspan='2'>Upgrade</th></tr>";
	if (-e "/usr/local/cpanel/whostmgr/docroot/cgi/cmmnocheck") {
		open (IN, "<", "/usr/local/cpanel/whostmgr/docroot/cgi/cmmnocheck");
		flock (IN, LOCK_SH);
		my $time = <IN>;
		close (IN);
		chomp $time;
		$retry = time - $time;
		if ($retry > $retrytime) {unlink ("/usr/local/cpanel/whostmgr/docroot/cgi/cmmnocheck")}
	}
	unless (-e "/usr/local/cpanel/whostmgr/docroot/cgi/cmmnocheck") {
		my ($status, $text) = &urlget("https://download.configserver.com/cmm/cmmversion.txt");
		my $actv = $text;
		my $up = 0;

		if ($actv ne "") {
			if ($actv =~ /^[\d\.]*$/) {
				if ($actv > $myv) {
					print "<tr bgcolor='#F4F4EA'><form action='$script' method='post'><td><input type='hidden' name='action' value='upgrade'><input type='submit' class='input' value='Upgrade cmm'></td><td width='100%'><b>A new version of cmm (v$actv) is available. Upgrading will retain your settings<br><a href='https://download.configserver.com/cmm/CHANGELOG.txt' target='_blank'>View ChangeLog</a></b></td></form></tr>\n";
				} else {
					print "<tr bgcolor='#F4F4EA'><td colspan='2'>You are running the latest version of cmm.<br>An Upgrade button will appear here if a new version becomes available</td></tr>\n";
				}
				$up = 1;
			}
		}
		unless ($up) {
			sysopen (OUT, "/usr/local/cpanel/whostmgr/docroot/cgi/cmmnocheck", O_WRONLY | O_CREAT);
			flock (OUT, LOCK_EX);
			print OUT time;
			close (OUT);
			print "<tr bgcolor='#F4F4EA'><td colspan='2'>Unable to connect to http://www.configserver.com, retry in $retrytime seconds.<br>An Upgrade button will appear here if new version is detected</td></tr>\n";
		}
	} else {
			print "<tr bgcolor='#F4F4EA'><td colspan='2'>Unable to connect to http://www.configserver.com, retry in ".($retrytime - $retry)." seconds.<br>An Upgrade button will appear here if new version is detected</td></tr>\n";
	}

	print "</table></form>\n";
}

print "<pre style='font-family: Courier New, Courier; font-size: 12px'>cmm: v$myv</pre>";
print "<p>&copy;2006-2015, <a href='http://www.configserver.com' target='_blank'>ConfigServer Services</a> (Way to the Web Limited)</p>\n";
print "</BODY>\n</HTML>\n";
# end main
###############################################################################
# start drop
sub drop {
	my $user = shift;
	my (undef,undef,$uid,$gid,undef,undef,undef,$home) = getpwnam($user);
	if ($> == 0) {
		chdir($home);
		$) = $( = $gid;
		$> = $< = $uid;
		if (($) != $gid) or ($> != $uid) or ($( != $gid) or ($< != $uid)) {print "Failed to drop privileges ($uid:$gid)\n";exit}
		$ENV{'REMOTE_USER'} = $user;
	}
}
# end drop
###############################################################################
sub uri_escape {
	my $string = shift;
	$string =~ s/([^^A-Za-z0-9\-_.!~*'()])/ sprintf "%%%0x", ord $1 /eg;
	return $string;
}

###############################################################################
# start urlget (v1.3)
#
# Examples:
#my ($status, $text) = &urlget("http://prdownloads.sourceforge.net/clamav/clamav-0.92.tar.gz","/tmp/clam.tgz");
#if ($status) {print "Oops: $text\n"}
#
#my ($status, $text) = &urlget("http://www.configserver.com/free/msfeversion.txt");
#if ($status) {print "Oops: $text\n"} else {print "Version: $text\n"}
#
sub urlget {
	my $url = shift;
	my $file = shift;
	my $status = 0;
	my $timeout = 1200;

	use LWP::UserAgent;
	my $ua = LWP::UserAgent->new;
	$ua->timeout(30);
	my $req = HTTP::Request->new(GET => $url);
	my $res;
	my $text;

	($status, $text) = eval {
		local $SIG{__DIE__} = undef;
		local $SIG{'ALRM'} = sub {die "Download timeout after $timeout seconds"};
		alarm($timeout);
		if ($file) {
			$|=1;
			my $expected_length;
			my $bytes_received = 0;
			my $per = 0;
			my $oldper = 0;
			open (OUT, ">$file\.tmp") or return (1, "Unable to open $file\.tmp: $!");
			binmode (OUT);
			print "...0\%\n";
			$res = $ua->request($req,
				sub {
				my($chunk, $res) = @_;
				$bytes_received += length($chunk);
				unless (defined $expected_length) {$expected_length = $res->content_length || 0}
				if ($expected_length) {
					my $per = int(100 * $bytes_received / $expected_length);
					if ((int($per / 5) == $per / 5) and ($per != $oldper)) {
						print "...$per\%\n";
						$oldper = $per;
					}
				} else {
					print ".";
				}
				print OUT $chunk;
			});
			close (OUT);
			print "\n";
		} else {
			$res = $ua->request($req);
		}
		alarm(0);
		if ($res->is_success) {
			if ($file) {
				rename ("$file\.tmp","$file") or return (1, "Unable to rename $file\.tmp to $file: $!");
				return (0, $file);
			} else {
				return (0, $res->content);
			}
		} else {
			return (1, "Unable to download: ".$res->message);
		}
	};
	alarm(0);
	if ($@) {
		return (1, $@);
	}
	if ($text) {
		return ($status,$text);
	} else {
		return (1, "Download timeout after $timeout seconds");
	}
}
# end urlget
###############################################################################
1;
